<?php
/**
 * Class for loading and managing fonts
 *
 * 
 * @package    Auxin
 * @license    LICENSE.txt
 * @author     
 * @link       http://averta.net/phlox/
 * @copyright  (c) 2010-2018 
*/

if ( !class_exists('Auxin_Fonts_Settings' ) ):
class Auxin_Fonts_Settings {

    private $settings_api;

    function __construct() {
        $this->settings_api = new Auxin_Fonts_Settings_API;

        add_action( 'admin_init', array($this, 'admin_init') );
        add_action( 'admin_menu', array($this, 'admin_menu') );
    }

    function admin_init() {

        //set the settings
        $this->settings_api->set_sections( $this->get_settings_sections() );
        $this->settings_api->set_fields( $this->get_settings_fields() );

        //initialize settings
        $this->settings_api->admin_init();
    }

    function admin_menu() {
        add_submenu_page( 'themes.php', __('Auxin Fonts', 'auxin-fonts'), __('Auxin Fonts', 'auxin-fonts'), 'edit_theme_options', 'auxin_fonts', array($this, 'plugin_page') );
    }

    function get_settings_sections() {
        $sections = array(
            array(
                'id'    => 'auxin_fonts_styles',
                'title' => __( 'Set Custom Fonts', 'auxin-fonts' )
            )
        );
        return $sections;
    }

    /**
     * Returns all the settings fields
     *
     * @return array settings fields
     */
    function get_settings_fields() {
        $settings_fields = array(
            'auxin_fonts_styles' => array(
                array(
                    'name'              => 'main_content',
                    'label'             => __( 'Main Content', 'auxin-fonts' ),
                    'desc'              => __( 'Specifies content typography.', 'auxin-fonts' ),
                    'type'              => 'font'
                ),
                array(
                    'name'              => 'main_titles',
                    'label'             => __( 'Main Titles', 'auxin-fonts' ),
                    'desc'              => __( 'Main titles contain sections and widget titles.<br/>All <code>h1</code> to <code>h6</code> typography can be set here.', 'auxin-fonts' ),
                    'type'              => 'font'
                ),
                array(
                    'name'              => 'page_heading',
                    'label'             => __( 'Page Heading', 'auxin-fonts' ),
                    'desc'              => __( 'Specifies main title typography of page.', 'auxin-fonts' ),
                    'type'              => 'font'
                ),
                array(
                    'name'              => 'menu_typography',
                    'label'             => __( 'Menu Typography', 'auxin-fonts' ),
                    'desc'              => __( 'Specifies menu typography.', 'auxin-fonts' ),
                    'type'              => 'font'
                ),

            )
        );

        return $settings_fields;
    }

    function plugin_page() {
        echo '<div class="wrap">';

        $this->settings_api->show_navigation();
        $this->settings_api->show_forms();

        echo '</div>';
    }

    /**
     * Get all the pages
     *
     * @return array page names with key value pairs
     */
    function get_pages() {
        $pages = get_pages();
        $pages_options = array();
        if ( $pages ) {
            foreach ($pages as $page) {
                $pages_options[$page->ID] = $page->post_title;
            }
        }

        return $pages_options;
    }

}
endif;
