<?php

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die('No Naughty Business Please !');
}

// Abort loading if WordPress is upgrading
if ( defined( 'WP_INSTALLING' ) && WP_INSTALLING ) {
    return;
}

if ( is_admin() ) {
    require_once dirname(dirname(__FILE__)) . '/admin/class-auxin-fonts-settings-api.php';
    require_once dirname(dirname(__FILE__)) . '/admin/class-auxin-fonts-settings.php';
    new Auxin_Fonts_Settings();
    require_once dirname(dirname(__FILE__)) . '/admin/class-auxin-fonts.php';
    function AXI_FONT(){ return Auxin_Fonts::get_instance(); }
    AXI_FONT();
}

function auxin_fonts_load_fonts(){

    $font_urls = get_option( 'phlox_font_urls' );

    if( !is_array( $font_urls ) ){
        return false;
    }

    foreach ( $font_urls as $style_id => $font_enqueue_url ) {
        wp_enqueue_style ( $style_id, $font_enqueue_url, NULL, false );
    }
}

function auxin_fonts_load_styles() {
    echo '<style>' .get_option( 'auxin_fonts_css_string', '' ) . '</style>';
}

add_action( 'wp_enqueue_scripts','auxin_fonts_load_styles' );
add_action( 'wp_enqueue_scripts','auxin_fonts_load_fonts' );


function auxin_fonts_get_option( $option, $default = '' ) {
    $options = get_option( 'auxin_fonts_styles' );

    if ( isset( $options[$option] ) ) {
        return $options[$option];
    }

    return $default;
}

