<?php

namespace validacao;

/**
 * Description of Validacao
 *
 * @author José Érico C. Soares
 * @copyright (c) 2015, Start Tecnologia Web
 */
class Validacao {
    
    protected function isEmpty($value){
        if(empty($value)){
            return false;
        }
    }
    
    protected function isEmail($value){
        if(!filter_var($value, FILTER_VALIDATE_EMAIL)){
            return false;
        }
    }
    
    protected function isPhone($value){
        if(!preg_match("/^(\(0?\d{2}\)\s?|0?\d{2}[\s.-]?)\d{4,5}[\s.-]?\d{4}$/", $value)){
            return false;
        }
    }
    
    protected function isCep($value){
        if(!preg_match("/^[0-9]{5}-[0-9]{3}$/", $value)){
            return false;
        }
    }

    protected function isInteger($value){
        if(!filter_var($value, FILTER_VALIDATE_INT) === 0 || filter_var($value, FILTER_VALIDATE_INT === false)){
            return false;
        }
    }
    
    protected function isAlpha($value){
        if(!ctype_alpha($value)){
            return false;
        }
    }
    
    protected function maxLenght($value,$max){
        if(mb_strlen($value)>$max){
            return false;
        }
    }
    
    protected function minLenght($value,$min){
        if(mb_strlen($value)<$min){
            return false;
        }
    }

    protected function slug($str) {
        $str = strtolower(trim($str));
        $str = preg_replace('/[^a-z0-9-]/', '-', $str);
        $str = preg_replace('/-+/', "-", $str);
        return $str;
    }
}
